package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import data.scripts.util.SWP_AnamorphicFlare;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PhaseShuntDriveStats extends BaseShipSystemScript {

    private static final Color COLOR1 = new Color(255, 150, 200);
    private static final Color COLOR2 = new Color(255, 0, 200);
    private static final Color COLOR3 = new Color(255, 0, 255);
    private static final Vector2f ZERO = new Vector2f();

    public boolean activated = true;

    @Override
    public void apply(MutableShipStatsAPI stats, String id, State state, float effectLevel) {
        ShipAPI ship = (ShipAPI) stats.getEntity();

        if (state == State.IN) {
            activated = false;
        }

        if (state == State.OUT) {
            if (!activated) {
                StandardLight light = new StandardLight(ship.getLocation(), ZERO, ZERO, null);
                light.setIntensity(3f);
                light.setSize(600f);
                light.setColor(COLOR1);
                light.fadeOut(0.25f);
                LightShader.addLight(light);

                float fluxLevel = ship.getFluxTracker().getCurrFlux() / stats.getFluxCapacity().getBaseValue();
                float range = 700f / (1f + fluxLevel);
                Global.getCombatEngine().spawnExplosion(ship.getLocation(), ZERO, COLOR1, range, 0.25f);

                List<CombatEntityAPI> targets = new ArrayList<>(Global.getCombatEngine().getProjectiles().size() / 4);
                targets.addAll(CombatUtils.getProjectilesWithinRange(ship.getLocation(), range));
                targets.addAll(CombatUtils.getMissilesWithinRange(ship.getLocation(), range));
                targets.addAll(CombatUtils.getAsteroidsWithinRange(ship.getLocation(), range));
                float total = 0f;
                for (CombatEntityAPI target : targets) {
                    float level;
                    if (target instanceof DamagingProjectileAPI) {
                        DamagingProjectileAPI proj = (DamagingProjectileAPI) target;
                        if (proj.getBaseDamageAmount() <= 0) continue;
                        
                        if (proj.getDamageType() == DamageType.FRAGMENTATION) {
                            level = proj.getDamageAmount() * 0.25f + proj.getEmpAmount() * 0.25f;
                        } else {
                            level = proj.getDamageAmount() + proj.getEmpAmount() * 0.25f;
                        }
                    } else {
                        level = target.getMass();
                    }
                    float sqrtLevel = (float) Math.sqrt(level);
                    float sqrtLevel2 = (float) Math.sqrt(sqrtLevel);

                    SWP_AnamorphicFlare.createStripFlare(ship, new Vector2f(target.getLocation()), Global.getCombatEngine(), sqrtLevel / 20f, 1,
                                                         sqrtLevel / 20f, sqrtLevel / 5f, (float) Math.random() * 360f, 0f, 1f, COLOR2, COLOR3);

                    RippleDistortion ripple = new RippleDistortion(target.getLocation(), ZERO);
                    ripple.setSize(sqrtLevel * 15f);
                    ripple.setIntensity(sqrtLevel * 1.5f);
                    ripple.setFrameRate(240f / sqrtLevel2);
                    ripple.fadeInSize(sqrtLevel2 / 4f);
                    ripple.fadeOutIntensity(sqrtLevel2 / 4f);
                    DistortionShader.addDistortion(ripple);

                    Global.getCombatEngine().spawnEmpArc(ship, new Vector2f(target.getLocation()), new SimpleEntity(target.getLocation()), ship,
                                                         DamageType.ENERGY, 0f, 0f, 500f, null, sqrtLevel / 10f, COLOR2, COLOR3);
                    ship.getFluxTracker().increaseFlux(level, true);

                    Global.getCombatEngine().removeEntity(target);

                    total += level;
                }

                Global.getCombatEngine().addFloatingDamageText(ship.getLocation(), total, COLOR2, ship, ship);
                Global.getSoundPlayer().playSound("swp_phaseshuntdrive_impact", 1f, 0.25f + (float) Math.sqrt(total) / 30f, ship.getLocation(), ZERO);
            }
            activated = true;
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        activated = false;
    }
}
